# WordSentinel

**Contributors:** victorlago, maxouhell, guerricm
**Tags:** security, WordPress, headers, CSP, SSL  
**Requires at least:** 5.8  
**Tested up to:** 6.7
**Stable tag:** 1.0  
**Requires PHP:** 7.0  
**License:** GPLv3
**License URI:** https://www.gnu.org/licenses/gpl-3.0.html


Secure your WordPress website with advanced headers configuration, including Content Security Policy (CSP) and SSL analysis.

---

## Description

The **Word**Sentinel WordPress plugin enhances the security of your WordPress website by enabling configurable HTTP security headers and providing security grading from two popular services:

- **Mozilla Observatory**: Analyze your website's HTTP headers.
- **Qualys SSL Labs**: Test your website's SSL/TLS configuration.

### Features:
- Configure advanced HTTP headers like:
  - Content Security Policy (CSP)
  - Strict-Transport-Security (HSTS)
  - X-Frame-Options
  - Referrer-Policy
  - Permissions-Policy
- Security grading with a visually appealing dashboard.
- Real-time analysis using external APIs.
- Retry functionality with cooldown to prevent API abuse.
- Easy-to-use interface with toggles for header configuration.

== External Services ==

This plugin connects to third-party services to analyze a website’s security headers and SSL configuration.

- **Service:** Mozilla Observatory API  
  - **Purpose:** This service analyzes security headers for a given website.  
  - **Data Sent:** The scanned website URL is sent to the Mozilla Observatory API automatically when the plugin initializes and when a manual scan is requested.  
  - **Privacy Policy:** [https://www.mozilla.org/en-US/privacy/websites/](https://www.mozilla.org/en-US/privacy/websites/)  
  - **Terms of Service:** [https://www.mozilla.org/en-US/about/legal/terms/mozilla/](https://www.mozilla.org/en-US/about/legal/terms/mozilla/)  

- **Service:** Qualys SSL Labs API  
  - **Purpose:** This service analyzes a website’s SSL/TLS configuration.  
  - **Data Sent:** The scanned website URL is sent to the Qualys SSL Labs API automatically when the plugin initializes and when a manual scan is requested.  
  - **Privacy Policy:** [https://www.qualys.com/company/privacy/](https://www.qualys.com/company/privacy/)  
  - **Terms of Service:** [https://www.qualys.com/company/community-terms-of-use/](https://www.qualys.com/company/community-terms-of-use/)  

**Note:** These external services are queried automatically when the plugin initializes and when a user requests a manual scan. The plugin does not store or share any additional user data.

---

## Languages Supported
- English (default)
- Français (fr_FR)
- Deutsch (de_DE)
- Italiano (it_IT)
- Español (es_ES)
- Português Brasileiro (pt_PT)

---

## Installation

1. Upload the plugin files to the `/wp-content/plugins/wordsentinel/` directory or install the plugin through the WordPress plugins screen directly.
2. Activate the plugin through the 'Plugins' screen in WordPress.
3. Navigate to the **Word**Sentinel menu in the WordPress admin dashboard to configure your security headers.

---

## Frequently Asked Questions

### **1. What are HTTP security headers?**
HTTP security headers are a way to enhance the security of your website by instructing the browser on how to handle various types of requests.

### **2. Do I need coding skills to use this plugin?**
No! This plugin offers an intuitive user interface, making it easy to configure security settings.

### **3. Why does the "Scan" button have a cooldown?**
The cooldown prevents excessive API calls, ensuring compliance with the external services' rate limits.

---

## Changelog

### **1.0**
- Initial release.
- Dashboard integration with Mozilla Observatory and Qualys SSL Labs APIs.
- Retry functionality with countdown.

---

## Upgrade Notice

No upgrade notices available yet.

---

## License

This plugin is licensed under the GPLv2 or later. See the [GPLv2 License](https://www.gnu.org/licenses/gpl-2.0.html) for details.

---

## Support

For support, please visit [Nexsol Technologies](https://nexsol-tech.ch).
